module net.BurtonRadons.dig.platform.pane;

private import net.BurtonRadons.dig.platform.base;
private import net.BurtonRadons.dig.platform.control;

//private import std.c.windows.windows;


/** A sub-table element for grid-fitting, used for making more complex layouts.
  */
class Pane : Control
{
    private import net.BurtonRadons.dig.platform.frame;
    private import net.BurtonRadons.dig.platform.windows;
    private const wchar [] digPlatformClassName = "digPlatformPane";
    
    /** Setup the GUI class for windows. */
    static this ()
    {
        digPlatformWindowClass.style = 0;//CS_HREDRAW | CS_VREDRAW;
        digPlatformWindowClass.lpfnWndProc = &Frame.digPlatformWindowProc;
        digPlatformWindowClass.cbClsExtra = 0;
        digPlatformWindowClass.cbWndExtra = 0;
        digPlatformWindowClass.hInstance = hinst;
        digPlatformWindowClass.hCursor = (_HANDLE) LoadCursorA ((_HANDLE) 0, IDC_ARROW);
        digPlatformWindowClass.hbrBackground = (_HBRUSH) (COLOR_BTNFACE + 1);
        digPlatformWindowClass.lpszMenuName = null;
        digPlatformWindowClass.lpszClassName = wtoStringz (digPlatformClassName);
        std.c.windows.windows.RegisterClassA (&digPlatformWindowClass);
    }

    /** Create the pane. */
    this (Control parent)
    {
        super (parent);
        digPlatformStyle |= std.c.windows.windows.WS_CHILD | std.c.windows.windows.WS_VISIBLE;
        digPlatformHWNDCreate (0, digPlatformClassName, null, digPlatformStyle, (_HANDLE) 0);
        digPlatformPadX = digPlatformPadY = 0;
        digPlatformBorderX = digPlatformBorderY = 0;
    }

/+
#ifdef DoxygenMustSkipThis
+/

    static _WNDCLASS digPlatformWindowClass;

    override void digPlatformChildMoved (Control control)
    {
        digPlatformGridfit ();
        digPlatformMoved ();
    }
    
/+
#endif
+/
}